/*
** Copyright (c) 2000-2001 Matsushita Electric Industrial Co., Ltd.
** All Rights Reserved.
*/

/*=============================================================================
$Filename   sd_ioctl.c
$Date		04/03/04
$Log		04/03/04	rev0.1	쐬
$ 		Matsushita Electric Industrial Co.,Ltd.
=============================================================================*/

/****************************************/
/* wb_[̃CN[h               */
/****************************************/
#include <sd_api.h>

#include "SddApi.h"
#include "sd_ioctl.h"

extern volatile UINT16	CARD_IOFlag;	/* IO card Status */
extern volatile UINT16	CARD_ErrStatus;	/* G[Xe[^X */
extern volatile UCHAR	IO_InitFlag;	/* J[htO */
extern volatile UINT16	SD_RCA;
extern UINT16	IO_Num_Func;		/* Function Number */

volatile BOOL	ulSDIOCTL_SdCdIntr = FALSE;

/*=====================================================================
*** $Function   SD_P_Ioc_WP_Check
*** $Resume     CgveNg`FbNbp[֐
*** $Parameter  ULONG ulArg     R}hi܂͂̃|C^j
*** $Return 	ULONG SD_SUCCESSiɐj
*** $Note       CARD_WP_Check()֐̏ɂԂ֐
=====================================================================*/
ULONG   SD_P_Ioc_WP_Check(ULONG ulArg)
{
	SDD_ERROR SddErr;
	SDD_WP	tSddWp;

	tSddWp.uw_CheckWP = SDD_WP_ALL;
	SddErr = SDD_Ioctl(ptSDD_Handle_Nor, SDD_IOC_CHECK_WP, 0, &tSddWp);
	if(SddErr != SDD_SUCCESS){
		return(SddErr);
	}

	*(ULONG *)ulArg = tSddWp.uw_Result;

	return SD_SUCCESS;
}

/*=====================================================================
*** $Function   SD_P_IocGetCardSize
*** $Resume     J[hTCY擾bp[֐iS̈j
*** $Parameter  ULONG ulArg     R}hi܂͂̃|C^j
*** $Return 	ULONG SD_SUCCESSiɐj
*** $Note       CARD_GetCardSize()֐̏ɂԂ֐
=====================================================================*/
ULONG   SD_P_IocGetCardSize(ULONG ulArg)
{
	SDD_ERROR SddErr;
	UW	uw_Capacity;

#if 1	/* SS12_20080821 MarvieAVł͒ʏ̈̃TCYԂ */
	SddErr = SDD_Ioctl(ptSDD_Handle_Nor, SDD_IOC_GET_AREA_SIZE, 0, &uw_Capacity);
#else	/* SS12_20080821 MarvieAVł͒ʏ̈̃TCYԂ */
	SddErr = SDD_Ioctl(ptSDD_Handle_Nor, SDD_IOC_GET_CARD_CAPACITY, 0, &uw_Capacity);
#endif	/* SS12_20080821 MarvieAVł͒ʏ̈̃TCYԂ */
	if(SddErr != SDD_SUCCESS){
		*(ULONG *)ulArg = 0;
		return(SddErr);
	}

	*(ULONG *)ulArg = uw_Capacity;

	return SD_SUCCESS;
}

/*===================================================================
*** $Function   SD_P_IocGetNomSize
*** $Resume     J[hTCY擾bp[֐iʏ̈j
*** $Parameter  ULONG ulArg     R}hi܂͂̃|C^j
*** $Return 	ULONG SD_SUCCESSiɐj
*** $Note       CARD_GetNomSize()֐̏ɂԂ֐
===================================================================*/
ULONG	SD_P_IocGetNomSize(ULONG ulArg)
{
	SDD_ERROR SddErr;
	UW	uw_Size;

	SddErr = SDD_Ioctl(ptSDD_Handle_Nor, SDD_IOC_GET_AREA_SIZE, 0, &uw_Size);
	if(SddErr != SDD_SUCCESS){
		return(SddErr);
	}

	*(ULONG *)ulArg = uw_Size;

	return SD_SUCCESS;
}

/*=====================================================================
*** $Function   SD_P_Cb_CardInOut
*** $Resume     J[h}R[obN֐
*** $Parameter  UW	uw_Event      [in] Cxg
                UW	uw_Param1     [in] o^ɐݒ肵Cӂ̒l
                UW	uw_Param2     [in]CxgɉSDfoCXhCoݒ肷p[^
*** $Return     
*** $Note       hCoɓo^J[hroR[obN֐
=====================================================================*/
void SD_P_Cb_CardInOut(UW uw_Event, UW uw_Param1, UW uw_Param2)
{
	int	i;
	UW uw_CardInOut;

	if(ulSDIOCTL_SdCdIntr == FALSE){
		return;
	}

	if(uw_Event == SDD_EVENT_CARD_OUT){
		/* J[h */
		uw_CardInOut = EVENT_CARD_REMOVAL;
	}
	else if(uw_Event == SDD_EVENT_CARD_IN){
		/* J[h} */
		uw_CardInOut = EVENT_CARD_INSERTION;
	}
	else{
		/* J[h}Cxgł͖ */
		return;
	}

	for(i=0 ; i<9 ; i++){
		if(gSDStatus.event_handler[i]){	// 荞݃nho^
			gSDStatus.event_handler[i](uw_CardInOut);	// nhs
		}
	}
}

/*=====================================================================
*** $Function   SD_P_Ioc_MPInit
*** $Resume     hCobp[֐
*** $Parameter  ULONG ulArg     R}hi܂͂̃|C^j
*** $Return     ULONG CARD_ErrStatus
*** $Note       o͐R}h SD_IOC_SET_INIT ɑΉ鏈
=====================================================================*/
ULONG	SD_P_Ioc_MPInit(ULONG ulArg)
{
	SDD_ERROR	SddErr;
	SDD_INIT	SddInit;

	SddInit.vp_CardInFunc = (void *)&(SD_P_Cb_CardInOut);	/* 	J[h}R[obN	*/
	SddInit.uw_CardInParam = 1;								/* 	J[h}R[obN	*/
	SddInit.vp_CardOutFunc = (void *)&(SD_P_Cb_CardInOut);	/* 	J[hroR[obN	*/
	SddInit.uw_CardOutParam = 4;							/* 	J[hroR[obN	*/

	if(ulArg & 0x01){ //@2009.8.26 SD Driver Init On
		SddErr = SDD_Ioctl(ptSDD_Handle_Nor, SDD_IOC_INIT, 0, &SddInit);
		if(SddErr != SDD_SUCCESS){
			return(SddErr);
		}
	}

	if(ulArg & 0x02){ //@2009.8.26 SD Card Init On
		SddErr = SDD_Ioctl(ptSDD_Handle_Nor, SDD_IOC_CARD_INIT, SDD_CARD_INIT_HARD, NULL);
		if(SddErr != SDD_SUCCESS){
			return(SddErr);
		}
	}

	return SD_SUCCESS;
}

#if 1	/* SDRAgݍ*/
/*=====================================================================
*** $Function   SD_P_Ioc_TimerStart
*** $Resume     ^C}X^[gbp[֐
*** $Parameter  ULONG ulArg     R}hi܂͂̃|C^j
*** $Return     ULONG SD_SUCCESSiɐ*** $Note       o͐R}h SD_IOC_SET_TIMER_START ɑΉ鏈
=====================================================================*/
ULONG	SD_P_Ioc_TimerStart(ULONG ulArg)
{
#if 0	/* ^C}@\͖gp	*/
	STR_SD_SET_TIMER_START		*pstrArg;
	pstrArg = (STR_SD_SET_TIMER_START *)(ulArg);

	/* ^C}X^[g֐call */
	CARD_TimerStart(pstrArg->ulTime);

#endif	/* ^C}@\͖gp	*/
	return SD_SUCCESS;
}

/*=====================================================================
*** $Function   SD_P_Ioc_TimerStop
*** $Resume     ^C}Xgbvbp[֐
*** $Parameter  ULONG ulArg     R}hi܂͂̃|C^j
*** $Return     ULONG SD_SUCCESSiɐj
*** $Note       o͐R}h SD_IOC_SET_TIMER_STOP ɑΉ鏈
=====================================================================*/
ULONG	SD_P_Ioc_TimerStop(ULONG ulArg)
{
#if 0	/* ^C}@\͖gp	*/
	/* ^C}Xgbv֐call */
	CARD_TimerStop();

#endif	/* ^C}@\͖gp	*/
	return SD_SUCCESS;
}
#endif	/* SDRAgݍ*/

/*=====================================================================
*** $Function   SD_P_Ioc_InsDel_Intr
*** $Resume     J[h}roݐ䃉bp[֐
*** $Parameter  ULONG ulArg     R}hi܂͂̃|C^j
*** $Return     ULONG SD_SUCCESSiɐj
*** $Note       o͐R}h SD_IOC_SET_INSDEL_INTR ɑΉ鏈
=====================================================================*/
ULONG	SD_P_Ioc_InsDel_Intr(ULONG ulArg)
{
	STR_SD_SET_INSDEL_INTR		*pstrArg;
	pstrArg = (STR_SD_SET_INSDEL_INTR *)(ulArg);

	/* J[h}roݐ֐call */
	ulSDIOCTL_SdCdIntr = pstrArg->ulIntr;	/* Enable/Disable SD Card (IO3 Detected) Inserted/Removed Interrupt */

	return SD_SUCCESS;
}

/*============================================================================
*** $Function	SD_P_IocRequestIrq
*** $Resume	NCAghCo荞݃nho^
*** $Parameter	ULONG ulArg	R}hi܂͂̃|C^j
*** $Return	SD_SUCCESS	I
***		̑		ُI
*** $Note	o͐R}h SD_IOC_REQUEST_IRQ ɑΉ鏈
=============================================================================*/
ULONG	SD_P_IocRequestIrq(ULONG ulArg)
{
	if(!gSDStatus.event_handler[gSDStatus.fd]){ // 荞݃nho^
		gSDStatus.event_handler[gSDStatus.fd] = (UINT32 (*)(UINT32))ulArg;		// nho^
		return SD_SUCCESS;
	}else{
		return -EBUSY;
	}

}

/*============================================================================
*** $Function	SD_P_IocFreeIrq
*** $Resume	NCAghCo荞݃nho^폜
*** $Parameter	ULONG ulArg		R}hi܂͂̃|C^j
*** $Return	ULONG SD_SUCCESSiɐj
*** $Note	o͐R}h SD_IOC_FREE_IRQ ɑΉ鏈
============================================================================*/
ULONG	SD_P_IocFreeIrq(ULONG ulArg)
{
	gSDStatus.event_handler[gSDStatus.fd] = NULL;	// nho^폜
	return SD_SUCCESS;
}


/*=====================================================================
*** $Function	SD_P_IocGetStatus
*** $Resume	J[hhCoԎ擾io͐䏈j
*** $Parameter	ULONG ulArg		R}hi܂͂̃|C^j	
***		USHORT * : STATUSi[ꏊ̃|C^
*** $Return	SD_SUCCESS	I
***		̑		ُI
*** $Note	o͐R}h SD_IOC_GET_STATUS ɑΉ鏈
***		*-*-* 擾l *-*-*
***		bit15 -- SDJ[hʃrbg		(o1)
***		bit14 -- MMCJ[hʃrbg	(o1)
***		bit10 -- IO3 card detect		(o0)
***		bit9 --- IO3 card inserted		(}0)
***		bit8 --- IO3 card removed		(E0)
***		bit7 --- write protect			(݋֎~̏ꍇ0)
***		bit6 --- reserved
***		bit5 --- card detect			(o0)
***		bit4 --- card inserted			(}0)
***		bit3 --- card removed			(E0)
***		bit2 --- R/W access all end		(o0)
***		bit1 --- Buffer RAM data detect	(o1)
***		bit0 --- Response end			(o0)
=====================================================================*/
ULONG	SD_P_IocGetStatus( ULONG ulArg)
{
	SDD_ERROR	SddErr;
	SDD_WP		tSddWp;
	UW			uw_CardType = 0;
	UH			uhStatus = 0;

	SddErr = SDD_Ioctl(ptSDD_Handle_Nor, SDD_IOC_GET_CARD_TYPE, 0, &uw_CardType);
	if(SddErr != SDD_SUCCESS){
		return(SddErr);
	}

	if(uw_CardType == SDD_CARD_TYPE_NOCARD){
		uhStatus |= 0x0420;
	}
	if(uw_CardType == SDD_CARD_TYPE_SD){
		uhStatus |= 0x8000;
	}
	if(uw_CardType == SDD_CARD_TYPE_MMC){
		uhStatus |= 0x4000;
	}

	tSddWp.uw_CheckWP = SDD_WP_ALL;
	SddErr = SDD_Ioctl(ptSDD_Handle_Nor, SDD_IOC_CHECK_WP, 0, &tSddWp);
	if(SddErr != SDD_SUCCESS){
		if((SddErr == SDD_ERR_NO_CARD) || (SDD_ERR_NOT_CARD_INIT)){
			/* J[hAJ[h̓G[ɂȂ */
			*((UH *)ulArg) = uhStatus;
			return SDD_SUCCESS;
		}
		return(SddErr);
	}

	if(tSddWp.uw_Result != 0){
		uhStatus |= 0x0080;
	}

	*((UH *)ulArg) = uhStatus;

	return	(ULONG)SddErr;
}

/*=====================================================================
*** $Function	SD_P_IocGetInfo
*** $Resume		J[hhCo擾io͐䏈j
*** $Parameter	ULONG ulArg		R}hi܂͂̃|C^j	
***		USHORT * : i[ꏊ̃|C^
*** $Return	ULONG SD_SUCCESSiɐj
*** $Note	o͐R}h SD_IOC_GET_INFO ɑΉ鏈
=====================================================================*/
ULONG	SD_P_IocGetInfo( ULONG ulArg)
{
	SDD_ERROR	SddErr;

	SddErr = SDD_Ioctl(ptSDD_Handle_Nor, SDD_IOC_GET_CARD_INFO, 0, (UW *)ulArg);

	return	(ULONG)SddErr;
}

/*=====================================================================
*** $Function	SD_P_IocReadExtrSingle
*** $Resume		CMD48 Extension Register Readsio͐䏈j
*** $Parameter	ULONG ulArg		R}hi܂͂̃|C^j	
***		USHORT * : i[ꏊ̃|C^
*** $Return	ULONG SD_SUCCESSiɐj
*** $Note	o͐R}h SD_IOC_READ_EXTR_SINGLE ɑΉ鏈
=====================================================================*/
ULONG	SD_P_IocReadExtrSingle( ULONG ulArg)
{
	SDD_ERROR	SddErr;

	SddErr = SDD_Ioctl(ptSDD_Handle_Nor, SDD_IOC_READ_EXTR_SINGLE, 0, (UW *)ulArg);

	return	(ULONG)SddErr;
}

/*=====================================================================
*** $Function	SD_P_IocWriteExtrSingle
*** $Resume		CMD49 Extension Register Writesio͐䏈j
*** $Parameter	ULONG ulArg		R}hi܂͂̃|C^j	
***		USHORT * : i[ꏊ̃|C^
*** $Return	ULONG SD_SUCCESSiɐj
*** $Note	o͐R}h SD_IOC_WRITE_EXTR_SINGLE ɑΉ鏈
=====================================================================*/
ULONG	SD_P_IocWriteExtrSingle( ULONG ulArg)
{
	SDD_ERROR	SddErr;

	SddErr = SDD_Ioctl(ptSDD_Handle_Nor, SDD_IOC_WRITE_EXTR_SINGLE, 0, (UW *)ulArg);

	return	(ULONG)SddErr;
}

#ifdef _SDD_FUNC_SECURE_
#endif /* _SDD_FUNC_SECURE_ */	/* 20080925 NonSecure */

#if 1	/* SS12 SDhCoAPIʉ */
#ifdef _SDD_C2_	/* SDRA C2@\g*/
#endif /* _SDD_C2_ */
#endif	/* SS12 SDhCoAPIʉ */

#if 1	/* SDRAgݍ	*/
#else	/* SDRAgݍ	*/
#if SDIO
/*=====================================================================
*** $Function	SD_P_IocSetIoReadDirect
*** $Resume	CMD52 Readsio͐䏈j
*** $Parameter	ULONG ulArg	R}hi܂͂̃|C^j
***		STR_SD_SET_IO_READ_DIRECT * : p\
*** $Return	SD_SUCCESS	I
***		̑		ُI
*** $Desc	R}h52@Reads
*** $Note	o͐R}h SD_IOC_SET_IO_READ_DIRECT ɑΉ鏈
=====================================================================*/
ULONG	SD_P_IocSetIoReadDirect( ULONG ulArg )
{
	STR_SD_SET_IO_READ_DIRECT*	pstrArg;
	UINT16 iRet = SD_SUCCESS;

	pstrArg = (STR_SD_SET_IO_READ_DIRECT*)ulArg;
	iRet = IO_ReadDIRECT( pstrArg->ulReadAdd, pstrArg->ucFuncNo );

	return	(ULONG)iRet;

}

/*=====================================================================
*** $Function	SD_P_IocSetIoWriteDirect
*** $Resume	CMD52 Writesio͐䏈j
*** $Parameter	ULONG ulArg	R}hi܂͂̃|C^j
***		STR_SD_SET_IO_WRITE_DIRECT * : p\	
*** $Return	SD_SUCCESS	I
***		̑		ُI
*** $Desc	R}h52@Writes
*** $Note	o͐R}h SD_IOC_SET_IO_WRITE_DIRECT ɑΉ鏈
=====================================================================*/
ULONG	SD_P_IocSetIoWriteDirect( ULONG ulArg )
{
	STR_SD_SET_IO_WRITE_DIRECT*	 pstrArg;
	UINT16 iRet = SD_SUCCESS;

	pstrArg = (STR_SD_SET_IO_WRITE_DIRECT*)ulArg;
	iRet = IO_WriteDIRECT( pstrArg->ulWriteAdd, pstrArg->ucWriteData, pstrArg->ucFuncNo);

	return	(ULONG)iRet;

}

/*=====================================================================
*** $Function	SD_P_IocGetIoR5
*** $Resume	R5X|X擾io͐䏈j
*** $Parameter	ULONG ulArg	R}hi܂͂̃|C^j	
***		USHORT * : R5̃X|Xli[̈̃|C^	
*** $Return	SD_SUCCESS	I
*** $Desc	R5X|X擾
*** $Note	o͐R}h SD_IOC_GET_IO_R5 ɑΉ鏈
=====================================================================*/
ULONG	SD_P_IocGetIoR5( ULONG ulArg )
{

	*((USHORT*)ulArg) = IO_GetR5();

	return SD_SUCCESS;
}

/*=====================================================================
*** $Function	SD_P_IocSetIoReadExtended
*** $Resume	CMD53 }`ANZX[hio͐䏈j
*** $Parameter	ULONG ulArg	R}hi܂͂̃|C^j
***		STR_SD_SET_IO_READ_EXTENDED * : p\	
*** $Return	SD_SUCCESS	I
***		̑		ُI
*** $Desc	R}h53 }`ANZX[h
*** $Note	o͐R}h SD_IOC_SET_IO_READ_EXTENDED ɑΉ鏈
=====================================================================*/
ULONG	SD_P_IocSetIoReadExtended( ULONG ulArg )
{
	STR_SD_SET_IO_READ_EXTENDED	*pstrArg;
	USHORT	unBlockMode;
	USHORT	unOpCode;
	UINT16 iRet = SD_SUCCESS;

	pstrArg = (STR_SD_SET_IO_READ_EXTENDED*)ulArg;

	if(pstrArg->unBlockMode == IO_ARG_BLOCKMODE) {
		unBlockMode = IO_ARG_BLOCKMODE;
	}
	else {
		unBlockMode = IO_ARG_BYTEMODE;
	}
	if(pstrArg->unOpCode == IO_ARG_OP_INC) {
		unOpCode = IO_ARG_OP_INC;
	}
	else {
		unOpCode = IO_ARG_OP_FIX;
	}

	iRet = IO_ReadEXTENDED( pstrArg->pvBuf, pstrArg->ulBufSize, pstrArg->ulReadAdd, unBlockMode, unOpCode, pstrArg->ucFuncNo );

	return (ULONG)iRet;
}

/*=====================================================================
*** $Function	SD_P_IocSetIoWriteExtended
*** $Resume	CMD53 }`ANZXCgio͐䏈j
*** $Parameter	ULONG ulArg	R}hi܂͂̃|C^j	
***		STR_SD_SET_IO_WRITE_EXTENDED * : p\
*** $Return	D_NORMAL	I
***		̑		ُI
*** $Desc	R}h53 }`ANZXCg
*** $Note	o͐R}h SD_IOC_SET_IO_WRITE_EXTENDED ɑΉ鏈
=====================================================================*/
ULONG	SD_P_IocSetIoWriteExtended( ULONG ulArg )
{
	STR_SD_SET_IO_WRITE_EXTENDED	*pstrArg;
	USHORT	unBlockMode;
	USHORT	unOpCode;
	UINT16 iRet = SD_SUCCESS;

	pstrArg = (STR_SD_SET_IO_WRITE_EXTENDED*)ulArg;

	if(pstrArg->unBlockMode == IO_ARG_BLOCKMODE) {
		unBlockMode = IO_ARG_BLOCKMODE;
	}
	else {
		unBlockMode = IO_ARG_BYTEMODE;
	}
	if(pstrArg->unOpCode == IO_ARG_OP_INC) {
		unOpCode = IO_ARG_OP_INC;
	}
	else {
		unOpCode = IO_ARG_OP_FIX;
	}

	iRet = IO_WriteEXTENDED( pstrArg->pvBuf, pstrArg->ulBufSize, pstrArg->ulWriteAdd, unBlockMode, unOpCode, pstrArg->ucFuncNo );

	return (ULONG)iRet;
}

/*=====================================================================
*** $Function	SD_P_IocSetIoGoInactive
*** $Resume	J[hԂINACTIVE֑Jځio͐䏈j
*** $Parameter	ULONG ulArg	R}hi܂͂̃|C^j	
*** $Return	SD_SUCCESS	I
***		̑		ُI
*** $Desc	J[hԂINACTIVEԂ֑JڂB
*** $Note	o͐R}h SD_IOC_SET_IO_GO_INACTIVE ɑΉ鏈
=====================================================================*/
ULONG	SD_P_IocSetIoGoInactive( ULONG ulArg )
{
	UINT16 iRet = SD_SUCCESS;

	iRet = IO_GO_INACTIVE();

	return (ULONG)iRet;
}

/*=====================================================================
*** $Function	SD_P_IocSetIoFuncEnable
*** $Resume	J[he@\gp/sgpݒio͐䏈j
*** $Parameter	ULONG ulArg	R}hi܂͂̃|C^j
***		STR_SD_SET_IO_FUNC_ENABLE * : p\
*** $Return	SD_SUCCESS	I
***		̑		ُI
*** $Desc	J[h̊e@\̎gp/sgpݒ肷B
*** $Note	o͐R}h SD_IOC_SET_IO_FUNC_ENABLE ɑΉ鏈
=====================================================================*/
ULONG	SD_P_IocSetIoFuncEnable( ULONG ulArg )
{
	STR_SD_SET_IO_FUNC_ENABLE	*pstrArg;
	UINT16 iRet = SD_SUCCESS;

	pstrArg = (STR_SD_SET_IO_FUNC_ENABLE*)ulArg;
	iRet = IO_FuncEnable(pstrArg->bEnable, pstrArg->ucFuncNo);

	return iRet;
}

/*=====================================================================
*** $Function	SD_P_IocGetIoFuncReady
*** $Resume	J[he@\Ԏ擾io͐䏈j
*** $Parameter	ULONG ulArg	R}hi܂͂̃|C^j	
***		STR_SD_GET_IO_FUNC_READY * : p\
*** $Return	SD_SUCCESS	I
***		̑		ُI
*** $Desc	J[h̊e@\̏Ԃ擾B
*** $Note	o͐R}h SD_IOC_GET_IO_FUNCREADY ɑΉ鏈
=====================================================================*/
ULONG	SD_P_IocGetIoFuncReady( ULONG ulArg )
{
	STR_SD_GET_IO_FUNC_READY	*pstrArg;

	pstrArg = (STR_SD_GET_IO_FUNC_READY *)ulArg;

	*(pstrArg->pbReady) = IO_GetFuncReady(pstrArg->ucFuncNo);

	return	SD_SUCCESS;
}

/*============================================================================
*** $Function	SD_P_IocGetIoStatus
*** $Resume	J[h̎擾
*** $Parameter	ULONG ulArg		R}hi܂͂̃|C^j
***		ULONG * : 	G[l擾p̈̃|C^
***				2Byte: SD_ERRDETAIL WX^l
***				2Byte: SD_ERRTOUT_ WX^l
*** $Return	SD_SUCCESS	I
***				̑		ُI
***				SD_ERR_PARAM	p[^G[
*** $Desc	SD_ERRDETAILWX^SD_ERRTOUTWX^̒l擾B
***				SDIFɂG[荞ݔɎgpB
*** $Note	o͐R}h SD_IOC_GET_IO_STATUS ɑΉ鏈
***		*-*-* 擾l *-*-*
***		bit3`0 -- SDJ[h
***			INACTIVE	0	INACTIVE( J[hȂ)
***			MEM_MMC		1	MMC Memory ONLY Card
***			MEM_SD		2	SD Memory ONLY Card
***			IO_ONLY		3	SDIO ONLY Card
***			IO_COMBO	4	SDIO COMBO Card
***		bit7`4 -- SDIOJ[h
***			SDIO_NOTSTANDARD 	0	No SDIO standard interface
***			SDIO_FE_STEP1	 TBD	Step1FE`[i[J[h
***		bit8    -- write protect	(݋֎~̏ꍇ0)
***		bit12   -- J[h		(ς݂̏ꍇP)
***		bit13   -- J[hE	(OCallꂽJ[hE
***						ꂽꍇ0)
==============================================================================*/
ULONG	SD_P_IocGetIoStatus(ULONG ulArg)
{
	USHORT	*punStatus;
	UCHAR	funcCode;	// 2004.05.26
/*	UCHAR	CISTPL_FUNC[0x04];*/	/*SDRV1 ֐gp̂ߍ폜*/
	UCHAR	CISTPL_MANFID[0x06];
	UCHAR	tuple_code;;
	int i;

	punStatus = (USHORT*)(ulArg);

	*punStatus = 0x0000;	// ߂l(status)

	/* J[h */
//	*punStatus |= gSDStatus.unIOFlag;
	*punStatus |= CARD_IOFlag;

	/* SDIOJ[h */
//	*punStatus |= (gSDStatus.ucIOFuncCode[1] << 4);
//	funcCode = IO_GetFuncCode(IO_Num_Func);

	tuple_code = 0x20;
	IO_GetCIS(CISTPL_MANFID, tuple_code, IO_Num_Func);
//	for(i = 0; i < 6; i++)	printk("MANFID[%d] = %x\n",i, CISTPL_MANFID[i]);

	if(CISTPL_MANFID[0] == 0x80 && CISTPL_MANFID[4] == 0x00) {
		funcCode = 7;	// SD-Link11g
	} else if(CISTPL_MANFID[0] == 0xff && CISTPL_MANFID[4] == 0x00) {
		funcCode = 8;	// SD-Link11b
	} else {
	for(i = 0; i < 6; i++)	printk("MANFID[%d] = %x\n",i, CISTPL_MANFID[i]);
		funcCode = 3;	// Bluetooth
	}
	*punStatus |= (funcCode << 4);	// ʂTrbgڂ

	/* WriteProtect */
	*punStatus |= ((gSDStatus.pnp_info1 & SD_INFO1_WRITEPROTECT) << 1);	// ʂXrbgڂ

#if 0	// KvH
	/* J[hς */
	*punStatus |= ((gSDStatus.unRCA ? 1 : 0) << 12);

	/* J[hE */
	*punStatus |= (gSDStatus.insert << 13);
	gSDStatus.insert = 1;
#endif

	return SD_SUCCESS;
}

/*=====================================================================
*** $Function	SD_P_IocSetIoBusWidth
*** $Resume	SDJ[hoXݒ
*** $Parameter	ULONG ulArg	R}hi܂͂̃|C^j	
***		0: 1bitݒ  else: 4bitݒ
*** $Return	IO_SelectBusWidth̕Ԃl
*** $Desc	SDJ[h̃oXi1or4bitjI
*** $Note	o͐R}h SD_IOC_SET_IO_BUSWIDTH ɑΉ鏈
=====================================================================*/
ULONG	SD_P_IocSetIoBusWidth( ULONG ulArg )
{
	UINT16 b4bit;
	UINT16 iRet = SD_SUCCESS;

	b4bit = (UINT16)ulArg;
        iRet = IO_SelectBusWidth(b4bit);

	return iRet;
}

/*=====================================================================
*** $Function	SD_P_IocSetIoBlockLength
*** $Resume	]f[^ubNݒ
*** $Parameter	ULONG ulArg	R}hi܂͂̃|C^j	
*** $Return	IO_SetBlockLength̕Ԃl
*** $Desc	CMD53ubN[h̃f[^ubNݒ
*** $Note	o͐R}h SD_IOC_SET_IO_BLOCKLENGTH ɑΉ鏈
=====================================================================*/
ULONG   SD_P_IocSetIoBlockLength( ULONG ulArg )
{
	STR_SD_SET_IO_BLOCK_LENGTH    *pstrArg;
	UINT16 iRet = SD_SUCCESS;

	pstrArg = (STR_SD_SET_IO_BLOCK_LENGTH*)ulArg;
	iRet = IO_SetBlockLength(pstrArg->unLength, pstrArg->ucFuncNo);

	return iRet;
}
#endif	//SDIO
#endif	/* SDRAgݍ	*/

/*===[EOF]===================================================================*/
